-- Storm Shadow / SCALP by Currenthill

-- =============================== Storm Shadow / SCALP aircraft-launched cruise missile ==========================================

  SU24MU_STORMSHADOW_warhead = {
    mass                 = 450, 
    caliber              = 550,
    expl_mass            = 450, 
    piercing_mass        = 250, 
    other_factors        = { 1.0, 1.0, 1.0 },
    concrete_factors     = { 3.0, 1.0, 1.0 },
    concrete_obj_factor  = 2.0,
    obj_factors          = { 3.0, 1.0 },
    cumulative_factor    = 2.0,
    cumulative_thickness = 0.0,
}

  SU24MU_STORM_SHADOW = {
	category		= CAT_MISSILES,
	name			= "SU24MU_STORMSHADOW",
	displayName		= _("[CH] Storm Shadow ALCM"),
	user_name	 	= _("Storm Shadow"),
	mass			= 1300,
	model			= 'Su-24MU_StormShadow',
	wsTypeOfWeapon  = {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},
	Escort 			= 0,
	Head_Type 		= 5,  
	sigma 			= {3, 3, 3},
	M 				= 1300.0,   
	H_max 			= 30000.0,  
	H_min 			= -1,  
	Diam 			= 550.0,
	Cx_pil 			= 1,   
	D_max 			= 550000.0, 
	D_min 			= 10000.0,
	Head_Form 		= 0, 
	Life_Time 		= 9999.0,   
	Nr_max 			= 12,  
	v_min 			= 170.0,
	v_mid 			= 450.0,  
	Mach_max 		= 1.3,  
	t_b 			= 0.0,
	t_acc 			= 4.0, 
	t_marsh         = 1800.0,  
	Range_max 		= 550000.0, 
	H_min_t 		= 0.0,
	Fi_start 		= 3.14152,
    Fi_rak 			= 3.14152,
    Fi_excort 		= 3.14152,
    Fi_search 		= 99.9,
    OmViz_max 		= 99.9,	
	exhaust 		= { 1, 1, 1, 1 },
	X_back 			= -6.3,  
	Y_back 			= 0.0, 
	Z_back 			= 0.0,  
	Reflection 		= 0.025, 
	KillDistance 	= 0.0, 
	add_attributes = {"Cruise missiles"},	
	
	encyclopediaAnimation = {
		args = {
			[25] = 1.000000, -- wings open
		},
	},	

	warhead	= SU24MU_STORMSHADOW_warhead,
	warhead_air = SU24MU_STORMSHADOW_warhead,

	shape_table_data = 
	{
		{

			name	 = "SU24MU_STORMSHADOW";
			file  	 = "Su-24MU_StormShadow";   		
			life  	 = 1;
			fire  	 = { 0, 1};
			username = _("Storm Shadow");
			index = WSTYPE_PLACEHOLDER;
		},
	},
	
    class_name      = "wAmmunitionCruise",
    scheme          = "sat_cruise_missile",

	fm = {
		mass        = 1950,  
		caliber     = 0.697,  
		cx_coeff    = {1, 0.3, 0.65, 0.023, 1.6},
		L           = 6.6,
		I           = 1 / 12 * 2050.0 * 6.6 * 6.6,
		Ma          = 3,	
		Mw          = 10,
		wind_sigma	= 0.0,
		wind_time	= 0.0,
		Sw			= 1.7,
		dCydA		= {0.07, 0.036},
		A			= 0.08,
		maxAoa		= 0.2,
		finsTau		= 0.08,
		Ma_x		= 1.2,
		Ma_z		= 3,
		Mw_x		= 2.7,
		
		addDeplSw			= 0.8,
		no_wings_A_mlt		= 7,
		wingsDeplProcTime	= 5,
		wingsDeplDelay		= 1,	
	},
	
	seeker = {
		CEP 					= 3.0,		
		coalition				= 2,
		coalition_rnd_coeff		= 5.0,
		can_update_target_pos	= 1,
	},
	
	control_block ={
		seeker_activation_dist		= 20000,
		default_cruise_height		= 50,
		obj_sensor					= 0,
		can_update_target_pos		= 0,
		turn_before_point_reach		= 1,
		turn_hor_N					= 0.8,
		turn_max_calc_angle_deg		= 90,
		turn_point_trigger_dist		= 100,
		use_horiz_dist				= 1,
	},

	final_autopilot =		{
		delay				= 0,
		K					= 70,
		Ki					= 0,
		Kg					= 4,
		finsLimit			= 0.8,
		useJumpByDefault	= 1,
		J_Power_K			= 2.2,
		J_Diff_K			= 0.4,
		J_Int_K				= 0.001,
		J_Angle_K			= 0.6,
		J_FinAngle_K		= 0.75,
		J_Angle_W			= 2.0,
		J_Trigger_Vert		= 1,
		hKp_err				= 120,
		hKp_err_croll		= 0.04,
		hKd					= 0.005,
		max_roll			= 0.8,
	},
	
	cruise_autopilot = {
		delay				= 1,
		Kp_hor_err			= 240,
		Kp_hor_err_croll	= 0.06,
		Kd_hor				= 0,
		Kp_ver				= 9,
		Kii_ver				= 0.2,
		Kd_ver				= 0,
		Kp_eng				= 265,
		Ki_eng				= 0.003,
		Kd_eng				= 0,
		Kp_ver_st1			= 0.009,
		Kd_ver_st1			= 0.015,
		Kp_ver_st2			= 0.00018,
		Kd_ver_st2			= 0.00005,
		
		auto_terrain_following			= 1,
		auto_terrain_following_height	= 50,
		
		alg_points_num			= 7,
		alg_calc_time			= 1.5,
		alg_vel_k				= 6,
		alg_div_k				= 2,
		alg_max_sin_climb		= 0.8,
		alg_section_temp_points	= 3,
		alg_tmp_point_vel_k		= 1.5,
		no_alg_vel_k			= 10,
		
		max_roll			= 0.8,
		max_start_y_vel		= 50,
		stab_vel			= 315,
		finsLimit			= 0.8,
		estimated_N_max		= 6,
		eng_min_thrust		= -120,
		eng_max_thrust		= 3923,		
		
		inertial_km_error		= 4,		-- m for 1000m dist
		glide_height_eq_error	= 2,		-- percent
		glide_height_abs_error	= 1,
		stab_vel_abs_error		= 2.0,		
	},
	
	controller = {
		boost_start	= 0,
		march_start = 6,
	},

	boost = {	
		impulse								= 0,
		fuel_mass							= 0,
		work_time							= 0,
		boost_time							= 0,
		boost_factor						= 0,
		nozzle_position						= {{0, 0, 0}},
		nozzle_orientationXYZ				= {{0, 0, 0}},
		tail_width							= 0,
		smoke_color							= {0.0, 0.0, 0.0},
		smoke_transparency					= 0.0,
		custom_smoke_dissipation_factor		= 0.0,				
	},

	march = {
		impulse			= 3000,
		fuel_mass		= 255.0,
		work_time		= 999999,
		min_fuel_rate	= 0.005,
		min_thrust		= -100,
		max_thrust		= 3000,
		thrust_Tau		= 0.0017,
		
        nozzle_position                  	= {{-2.7, -0.456, 0.0}},
		nozzle_orientationXYZ				= {{0.0, 0.0, 0.0}},
		tail_width							= 0.3,
		smoke_color							= {0.5, 0.5, 0.5},
		smoke_transparency					= 0.01,
		custom_smoke_dissipation_factor		= 0.7,	
		
		start_burn_effect			= 0,
		start_effect_delay			= {0.0,		0.3, 	0.8},
		start_effect_time			= {0.7,		1.0, 	0.1},
		start_effect_size			= {0.09,	0.104,	0.11},
		start_effect_smoke			= {0.01,	0.4, 	0.01},
		start_effect_x_pow			= {1.0,		1.0,	1.0},
		start_effect_x_dist			= {1.1,		0.9,	0.0},
		start_effect_x_shift		= {0.15,	0.15,	0.2},
		
	},
	
	booster_animation = {
		start_val = 0,
	},
	
	play_booster_animation = {
		val = 0,
	},
	
}

declare_weapon(SU24MU_STORM_SHADOW)

declare_loadout(
	{
		category		= CAT_MISSILES,
		Picture			= "Stormshadow.png",
		wsTypeOfWeapon  = SU24MU_STORM_SHADOW.wsTypeOfWeapon,		
		displayName		= _("[CH] Storm Shadow ALCM"),
		CLSID			= "{SU24MU_STORMSHADOW}",
		attribute		= SU24MU_STORM_SHADOW.wsTypeOfWeapon,
		Count			= 1,
		Weight			= SU24MU_STORM_SHADOW.mass,
		Cx_pil			= 0.001, 	
		Elements		=
	{
		[1]	=	
		{
				DrawArgs	=
				{
					[1]	=	{1,	1},
					[2]	=	{2,	1},
				}, -- end of DrawArgs
				Position	=	{0,	0,	0},
				ShapeName	=	"Su-24MU_StormShadow",
					},
		}, -- end of Elements   
	}
)
